jQuery(function($){
	
	var map; //importante definirla fuera de la funcion initialize() para poderla usar desde otras funciones.
	//navigator.geolocation.getCurrentPosition(initialize);
	navigator.geolocation.getCurrentPosition(function(pos){
		initialize(pos);
	}, function (error){
		//en caso de no tener habilitada la opcion de compartir ubicación en el movil, mostramos un mensaje de aviso y cargamos un mapa por defecto 
		alert($("#lblMensajeUbicacion").text());
		initialize(null);
	});
	
	var miPosicion = null;
	
	 function initialize(pos) {
	   
		 var myOptions;
		 //si sabemos la posición del usuario
		 if (pos != null){
			 miPosicion = new google.maps.LatLng(pos.coords.latitude,pos.coords.longitude);
			 
			 myOptions = {
				 zoom: 14, //nivel de zoom para poder ver de cerca.
				 center: miPosicion,
				 mapTypeId: google.maps.MapTypeId.ROADMAP //Tipo de mapa inicial, satélite para ver las pirámides
			  };
		 }else{
			 //si no sabemos la posición del usuario, cargo el mapa centrado en euskadi y con un zoom mas lejano
			 myOptions = {
				 zoom: 9, //nivel de zoom para poder ver de cerca.
				 center: new google.maps.LatLng(43.122323, -2.636001),
				 mapTypeId: google.maps.MapTypeId.ROADMAP //Tipo de mapa inicial, satélite para ver las pirámides
			  };
		 }
		 
		 
		 var directionsDisplay = new google.maps.DirectionsRenderer();
		 
		 map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
		 
		 if (miPosicion != null){
			 var marker = new google.maps.Marker({
				position: miPosicion,
				animation: google.maps.Animation.DROP
			});
			 
			// To add the marker to the map, call setMap();
			marker.setMap(map);
		 }
		 
						
		
		fncGetEstaciones();
		
		//pinto el mapa
		directionsDisplay.setMap(map);
		
	 }
	 
	 function fncGetEstaciones(){
		
		//obtengo la lista de avisos generales
			$.ajax({
				url: CTX_PATH+"estaciones/lista?R01HNoPortal=true",
				dataType: 'json',
				type: "GET",
				async: false,
				contentType: 'application/json',		    
				success: function (resultado, ajaxOptions) {
					
					if (resultado != null){
						
						var cercana = null;
						var indexCercana = 0;
						
						//primero recorro la lista de estaciones para saber cual es la más cercana
						for (i=0;i<resultado.length;i++){						
							
							//si sabemos la posición del usuario
							if (miPosicion != null){
								//obtengo la distancia desde mi posicion hasta la estación
								var distancia = google.maps.geometry.spherical.computeDistanceBetween(miPosicion, new google.maps.LatLng(resultado[i].coordenadaLat, resultado[i].coordenadaLon));
	
								if (cercana == null || distancia < cercana){
									//si esta más cercana que la anterior, guardo la posicion 
									 cercana = distancia;
									 indexCercana = i;
								 }
							}
							
						}
						
						//ahora recorro otra vez la lista de estaciones para pintarlas en el mapa
						for (i=0;i<resultado.length;i++){	
							
							var blnMasCercana = false;
							//compruebo si se trata de la estación más cercana a mi posicion actual
							if (cercana != null && indexCercana == i){
								blnMasCercana = true;
							}
							
							setMarcadores(resultado[i], blnMasCercana);
						}
					}
					
					
				},
				error: function (xhr, ajaxOptions, thrownError) {
					alert(xhr.resultText);
				}
			});
	 }
	 
	 function setMarcadores(estacion, masCercana){
		var myLatlng2 = new google.maps.LatLng(estacion.coordenadaLat, estacion.coordenadaLon);
		//fuente iconos mapa: http://mapicons.nicolasmollet.com/
		var marker2 = new google.maps.Marker({
			position: myLatlng2,
			animation: google.maps.Animation.DROP,
			title: estacion.nombreEstacion,
			icon: APP_STATICS + "/images/" + estacion.banda.icono
		});

		google.maps.event.addListener(marker2, 'click', function() {
			location.href = CTX_PATH + "estaciones/detalle/" + estacion.idEstacion + "?R01HNoPortal=true";
		  });
		  
		// To add the marker to the map, call setMap();
		marker2.setMap(map);
		
		if (masCercana){
			
			marker2.setAnimation(google.maps.Animation.BOUNCE);
			
			var strHTML = "<div style='min-width: 200px;'>";
			strHTML += "<div><u>" + $("#lblEstacionMasCercana").text() + "</u></div>";
			strHTML += "<div><strong>" + estacion.nombreEstacion + "</strong></div>";
			strHTML += "<div>" + estacion.direccionEstacion + " - " + estacion.nombreMunicipio + " (" + estacion.nombreProvincia + ")</div>";
			strHTML += "<div>" + $("#lblICA").text() + ": " + estacion.banda.descripcion + "</div>";
			strHTML += '<br/>'; //meto un intro al final para dar espacio y que no oculte el texto en el scroll
			strHTML += "</div>";
			
			var infowindow = new google.maps.InfoWindow({content: strHTML});
			infowindow.open(map, marker2);
			map.panTo(myLatlng2);
		}
	 }
	
});